/*------------------------------------------------------------------------------*
 * File Name:	OCHDF5.h			 											*
 * Creation: 																	*
 * Purpose: OriginC Header file													*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#ifndef _OCHDF5_H_
#define	_OCHDF5_H_

#define	H5_DLL extern
#define H5OPEN
#define	H5_DLLVAR extern
//Sophy typedef DataTypes
typedef int htri_t;
typedef int hid_t;
typedef int herr_t;
typedef int ssize_t;
typedef double haddr_t;

typedef double hdf_time_t; ///Sophy, time_t in Origin is long type, but in hdf5dll, it is __time64_t, which also is __int64
typedef double uint64_t;
typedef double hssize_t; //should be __int64
typedef double hsize_t; //Sophy, should use a better data structure to substitude unsigned __int64
typedef haddr_t hobj_ref_t;
typedef	hssize_t int64_t;
//end DataTypes
/* Define user-level maximum number of dimensions */
#define H5S_MAX_RANK    32

#ifdef __cplusplus
extern "C" {
#endif

#pragma dll(hdf5dll)
//#pragma dll(D:\Documents and Settings\originlab\Desktop\hdf5-1.8.2\hdf5-1.8.2\proj\hdf5dll\Debug\hdf5ddll) //for debugging
//Sophy, change unsigned to uint if encounter while moving following lines from HDF5 lib

typedef enum H5_index_t {
    H5_INDEX_UNKNOWN = -1,	/* Unknown index type			*/
    H5_INDEX_NAME,		/* Index on names 			*/
    H5_INDEX_CRT_ORDER,		/* Index on creation order 		*/
    H5_INDEX_N			/* Number of indices defined 		*/
} H5_index_t;
    
/*
 * Storage info struct used by H5O_info_t and H5F_info_t

*/
typedef struct H5_ih_info_t {
    hsize_t     index_size;     /* btree and/or list */

    hsize_t     heap_size;
} H5_ih_info_t;

//H5G
typedef enum H5G_obj_t {
	H5G_UNKNOWN = -1,	/* Unknown object type		*/
    H5G_GROUP,			/* Object is a group		*/
    H5G_DATASET,		/* Object is a dataset		*/
    H5G_TYPE,			/* Object is a named data type	*/
    H5G_LINK,			/* Object is a symbolic link	*/
    H5G_UDLINK		/* Object is a user-defined link */   
} H5G_obj_t;

H5_DLL hid_t H5Gopen1(hid_t loc_id, const char *name);
H5_DLL herr_t H5Gclose(hid_t group_id);
H5_DLL herr_t H5Gget_num_objs(hid_t loc_id, hsize_t *num_objs);
H5_DLL H5G_obj_t H5Gget_objtype_by_idx(hid_t loc_id, hsize_t idx);
H5_DLL ssize_t H5Gget_objname_by_idx(hid_t loc_id, hsize_t idx, char* name, size_t size);
H5_DLL herr_t H5Gget_linkval( hid_t loc_id, const char *name, size_t size, char *value) ;
//end H5G

//H5O
/* Types of objects in file */
typedef enum H5O_type_t {
    H5O_TYPE_UNKNOWN = -1,	/* Unknown object type		*/
    H5O_TYPE_GROUP,	        /* Object is a group		*/
    H5O_TYPE_DATASET,		/* Object is a dataset		*/
    H5O_TYPE_NAMED_DATATYPE, 	/* Object is a named data type	*/
    H5O_TYPE_NTYPES             /* Number of different object types (must be last!) */
} H5O_type_t;
    
    
typedef struct H5O_info_t {
    unsigned long       fileno;         /* File number that object is         */
                                        /*    located in                      */
    haddr_t             addr;           /* Object address in file             */
    H5O_type_t          type;           /* Basic object type (group,          */
                                        /*    dataset, etc.)                  */
    uint	      		rc;             /* Reference count of object          */
    hdf_time_t          atime;          /* Access time                        */
    hdf_time_t          mtime;          /* Modification time                  */
    hdf_time_t          ctime;          /* Change time                        */
    hdf_time_t          btime;          /* Birth time                         */
    hsize_t             num_attrs;      /* # of attributes attached to object */
    struct _struct_hdr{
        uint	 version;               /* Version number of header format in */
                                        /*    file                            */
        uint	 nmesgs;                /* Number of object header messages   */
        uint	 nchunks;               /* Number of object header chunks     */
        uint	 flags;                 /* Object header status flags         */
        struct _struct_space{
            hsize_t total;              /* Total space for storing object     */
                                        /*    header in file                  */
            hsize_t meta;               /* Space within header for object     */
                                        /*    header metadata information     */
            hsize_t mesg;               /* Space within header for actual     */
                                        /*    message information             */
            hsize_t free;               /* Free space within object header    */
        } space;
        struct _struct_mesg{
            uint64_t present;           /* Flags to indicate presence of      */
                                        /*    message type in header          */
            uint64_t shared;            /* Flags to indicate message type is  */
                                        /*    shared in header                */
        } mesg;     
    } hdr;
    /* Extra metadata storage for obj & attributes */
    struct _struct_meta_size{
        H5_ih_info_t   obj;             /* v1/v2 B-tree & local/fractal heap  */
                                        /*    for groups, B-tree for chunked  */
                                        /*    datasets                        */
        H5_ih_info_t   attr;            /* v2 B-tree & heap for attributes    */
    } meta_size;
} H5O_info_t;

H5_DLL herr_t H5Oget_info_by_name( hid_t loc_id, const char *object_name, H5O_info_t *object_info, hid_t lapl_id);
H5_DLL herr_t H5Oclose(hid_t object_id);
//end H5O

//prototypes begin Files Operation H5F...
//file access control attribute
#define H5F_ACC_RDONLY	0x0000

//H5P
//H5_DLLVAR hid_t H5P_CLS_FILE_ACCESS_g;
#define H5P_DEFAULT		0
//end H5P

//H5F
/* Flags for H5Fget_obj_count() & H5Fget_obj_ids() calls */
#define H5F_OBJ_FILE	(0x0001)       /* File objects */
#define H5F_OBJ_DATASET	(0x0002)       /* Dataset objects */
#define H5F_OBJ_GROUP	(0x0004)       /* Group objects */
#define H5F_OBJ_DATATYPE (0x0008)      /* Named datatype objects */
#define H5F_OBJ_ATTR    (0x0010)       /* Attribute objects */
#define H5F_OBJ_ALL 	(H5F_OBJ_FILE|H5F_OBJ_DATASET|H5F_OBJ_GROUP|H5F_OBJ_DATATYPE|H5F_OBJ_ATTR)
#define H5F_OBJ_LOCAL   (0x0020)       /* Restrict search to objects opened through current file ID */
#define H5F_FAMILY_DEFAULT (hsize_t)0

H5_DLL htri_t H5Fis_hdf5(const char *filename);
H5_DLL hid_t  H5Fopen(const char *filename, uint flags, hid_t access_plist);
H5_DLL herr_t H5Fclose(hid_t file_id);
H5_DLL ssize_t H5Fget_obj_count(hid_t file_id, uint types);
//end H5F
//inquire methods
//get name from obj id
H5_DLL ssize_t H5Iget_name(hid_t id, char *name/*out*/, size_t size);

//prototypes end

//H5A Attributes
/* Common iteration orders */
typedef enum {
    H5_ITER_UNKNOWN = -1,       /* Unknown order */
    H5_ITER_INC,                /* Increasing order */
    H5_ITER_DEC,                /* Decreasing order */
    H5_ITER_NATIVE,             /* No particular order, whatever is fastest */
    H5_ITER_N		        /* Number of iteration orders */
 } H5_iter_order_t;   
    
typedef uint	hbool_t;
typedef	uint	H5O_msg_crt_idx_t;
typedef	int		H5T_cset_t; //actually, it is enum type.
/* Information struct for attribute (for H5Aget_info/H5Aget_info_by_idx) */
typedef struct {
    hbool_t             corder_valid;   /* Indicate if creation order is valid */
    H5O_msg_crt_idx_t   corder;         /* Creation order                 */
    H5T_cset_t          cset;           /* Character set of attribute name */
    hsize_t             data_size;      /* Size of raw data		  */
} H5A_info_t;

/* Information struct for attribute (for H5Aget_info/H5Aget_info_by_idx) */
typedef herr_t	(*H5A_operator2_t)(hid_t location_id/*in*/,	const char *attr_name/*in*/, const H5A_info_t *ainfo/*in*/, void *op_data/*in,out*/);

H5_DLL hid_t   H5Aopen(hid_t obj_id, const char *attr_name, hid_t aapl_id);
H5_DLL hid_t   H5Aopen_idx(hid_t loc_id, uint idx);
H5_DLL herr_t  H5Aclose(hid_t attr_id);
H5_DLL hid_t   H5Aget_type(hid_t attr_id);
H5_DLL int     H5Aget_num_attrs(hid_t loc_id);
H5_DLL ssize_t H5Aget_name(hid_t attr_id, size_t buf_size, char *buf);
H5_DLL herr_t  H5Aread(hid_t attr_id, hid_t type_id, void *buf);
H5_DLL hid_t   H5Aget_space(hid_t attr_id);

H5_DLL herr_t  H5Aiterate2(hid_t loc_id, H5_index_t idx_type, H5_iter_order_t order, hsize_t *idx, H5A_operator2_t op, void *op_data);

//end H5A

/* Iteration callback values */
/* (Actually, any postive value will cause the iterator to stop and pass back
 *      that positive value to the function that called the iterator)
 */
#define H5_ITER_ERROR   (-1)
#define H5_ITER_CONT    (0)
#define H5_ITER_STOP    (1)
//H5D
H5_DLL hid_t H5Dget_space(hid_t dset_id);
H5_DLL hid_t H5Dget_type(hid_t dset_id);
H5_DLL hid_t H5Dopen1(hid_t file_id, const char *name);
H5_DLL herr_t H5Dclose(hid_t dset_id);
H5_DLL herr_t H5Dread(hid_t dset_id, hid_t mem_type_id, hid_t mem_space_id, hid_t file_space_id, hid_t plist_id, void *buf/*out*/);
H5_DLL herr_t H5Dvlen_reclaim(hid_t type_id, hid_t space_id, hid_t plist_id, void *buf );
//end H5D

#define	H5OPEN		//do nothing
//H5T
/* Byte orders */
typedef enum H5T_order_t {
    H5T_ORDER_ERROR      = -1,  /*error                                      */
    H5T_ORDER_LE         = 0,   /*little endian                              */
    H5T_ORDER_BE         = 1,   /*bit endian                                 */
    H5T_ORDER_VAX        = 2,   /*VAX mixed endian                           */
    H5T_ORDER_NONE       = 3    /*no particular order (strings, bits,..)     */    
    /*H5T_ORDER_NONE must be last */
} H5T_order_t;    

H5_DLL H5T_order_t H5Tget_order(hid_t dtype_id);
H5_DLL herr_t H5Tset_order(hid_t dtype_id, H5T_order_t order);

/*
 * The IEEE floating point types in various byte orders.
 */
#define H5T_IEEE_F32BE		(H5OPEN H5T_IEEE_F32BE_g)
#define H5T_IEEE_F32LE		(H5OPEN H5T_IEEE_F32LE_g)
#define H5T_IEEE_F64BE		(H5OPEN H5T_IEEE_F64BE_g)
#define H5T_IEEE_F64LE		(H5OPEN H5T_IEEE_F64LE_g)
H5_DLLVAR hid_t H5T_IEEE_F32BE_g;
H5_DLLVAR hid_t H5T_IEEE_F32LE_g;
H5_DLLVAR hid_t H5T_IEEE_F64BE_g;
H5_DLLVAR hid_t H5T_IEEE_F64LE_g;

/*
 * These are "standard" types.  For instance, signed (2's complement) and
 * unsigned integers of various sizes and byte orders.
 */
#define H5T_STD_I8BE		(H5OPEN H5T_STD_I8BE_g)
#define H5T_STD_I8LE		(H5OPEN H5T_STD_I8LE_g)
#define H5T_STD_I16BE		(H5OPEN H5T_STD_I16BE_g)
#define H5T_STD_I16LE		(H5OPEN H5T_STD_I16LE_g)
#define H5T_STD_I32BE		(H5OPEN H5T_STD_I32BE_g)
#define H5T_STD_I32LE		(H5OPEN H5T_STD_I32LE_g)
#define H5T_STD_I64BE		(H5OPEN H5T_STD_I64BE_g)
#define H5T_STD_I64LE		(H5OPEN H5T_STD_I64LE_g)
#define H5T_STD_U8BE		(H5OPEN H5T_STD_U8BE_g)
#define H5T_STD_U8LE		(H5OPEN H5T_STD_U8LE_g)
#define H5T_STD_U16BE		(H5OPEN H5T_STD_U16BE_g)
#define H5T_STD_U16LE		(H5OPEN H5T_STD_U16LE_g)
#define H5T_STD_U32BE		(H5OPEN H5T_STD_U32BE_g)
#define H5T_STD_U32LE		(H5OPEN H5T_STD_U32LE_g)
#define H5T_STD_U64BE		(H5OPEN H5T_STD_U64BE_g)
#define H5T_STD_U64LE		(H5OPEN H5T_STD_U64LE_g)
#define H5T_STD_B8BE		(H5OPEN H5T_STD_B8BE_g)
#define H5T_STD_B8LE		(H5OPEN H5T_STD_B8LE_g)
#define H5T_STD_B16BE		(H5OPEN H5T_STD_B16BE_g)
#define H5T_STD_B16LE		(H5OPEN H5T_STD_B16LE_g)
#define H5T_STD_B32BE		(H5OPEN H5T_STD_B32BE_g)
#define H5T_STD_B32LE		(H5OPEN H5T_STD_B32LE_g)
#define H5T_STD_B64BE		(H5OPEN H5T_STD_B64BE_g)
#define H5T_STD_B64LE		(H5OPEN H5T_STD_B64LE_g)
#define H5T_STD_REF_OBJ	        (H5OPEN H5T_STD_REF_OBJ_g)
#define H5T_STD_REF_DSETREG     (H5OPEN H5T_STD_REF_DSETREG_g)

H5_DLLVAR hid_t H5T_STD_I8BE_g;

H5_DLLVAR hid_t H5T_STD_I8LE_g;
H5_DLLVAR hid_t H5T_STD_I16BE_g;
H5_DLLVAR hid_t H5T_STD_I16LE_g;
H5_DLLVAR hid_t H5T_STD_I32BE_g;
H5_DLLVAR hid_t H5T_STD_I32LE_g;
H5_DLLVAR hid_t H5T_STD_I64BE_g;
H5_DLLVAR hid_t H5T_STD_I64LE_g;
H5_DLLVAR hid_t H5T_STD_U8BE_g;
H5_DLLVAR hid_t H5T_STD_U8LE_g;
H5_DLLVAR hid_t H5T_STD_U16BE_g;
H5_DLLVAR hid_t H5T_STD_U16LE_g;
H5_DLLVAR hid_t H5T_STD_U32BE_g;
H5_DLLVAR hid_t H5T_STD_U32LE_g;
H5_DLLVAR hid_t H5T_STD_U64BE_g;
H5_DLLVAR hid_t H5T_STD_U64LE_g;
H5_DLLVAR hid_t H5T_STD_B8BE_g;
H5_DLLVAR hid_t H5T_STD_B8LE_g;
H5_DLLVAR hid_t H5T_STD_B16BE_g;
H5_DLLVAR hid_t H5T_STD_B16LE_g;
H5_DLLVAR hid_t H5T_STD_B32BE_g;
H5_DLLVAR hid_t H5T_STD_B32LE_g;
H5_DLLVAR hid_t H5T_STD_B64BE_g;
H5_DLLVAR hid_t H5T_STD_B64LE_g;
H5_DLLVAR hid_t H5T_STD_REF_OBJ_g;
H5_DLLVAR hid_t H5T_STD_REF_DSETREG_g;





//native types
#define H5T_NATIVE_SCHAR        (H5OPEN H5T_NATIVE_SCHAR_g)
#define H5T_NATIVE_UCHAR        (H5OPEN H5T_NATIVE_UCHAR_g)
#define	H5T_NATIVE_CHAR			H5T_NATIVE_SCHAR
#define H5T_NATIVE_SHORT        (H5OPEN H5T_NATIVE_SHORT_g)
#define H5T_NATIVE_USHORT       (H5OPEN H5T_NATIVE_USHORT_g)
#define H5T_NATIVE_INT          (H5OPEN H5T_NATIVE_INT_g)
#define H5T_NATIVE_UINT         (H5OPEN H5T_NATIVE_UINT_g)
#define H5T_NATIVE_LONG         (H5OPEN H5T_NATIVE_LONG_g)
#define H5T_NATIVE_ULONG        (H5OPEN H5T_NATIVE_ULONG_g)
#define H5T_NATIVE_LLONG        (H5OPEN H5T_NATIVE_LLONG_g)
#define H5T_NATIVE_ULLONG       (H5OPEN H5T_NATIVE_ULLONG_g)
#define H5T_NATIVE_FLOAT        (H5OPEN H5T_NATIVE_FLOAT_g)
#define H5T_NATIVE_DOUBLE       (H5OPEN H5T_NATIVE_DOUBLE_g)
#define	H5T_NATIVE_LDOUBLE		(H5OPEN H5T_NATIVE_LDOUBLE_g)

#define H5T_NATIVE_B8		(H5OPEN H5T_NATIVE_B8_g)
#define H5T_NATIVE_B16		(H5OPEN H5T_NATIVE_B16_g)
#define H5T_NATIVE_B32		(H5OPEN H5T_NATIVE_B32_g)
#define H5T_NATIVE_B64		(H5OPEN H5T_NATIVE_B64_g)


H5_DLLVAR hid_t	H5T_NATIVE_SCHAR_g;
H5_DLLVAR hid_t	H5T_NATIVE_UCHAR_g;
H5_DLLVAR hid_t	H5T_NATIVE_SHORT_g;
H5_DLLVAR hid_t	H5T_NATIVE_USHORT_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_g;
H5_DLLVAR hid_t	H5T_NATIVE_UINT_g;
H5_DLLVAR hid_t	H5T_NATIVE_LONG_g;
H5_DLLVAR hid_t	H5T_NATIVE_ULONG_g;
H5_DLLVAR hid_t H5T_NATIVE_FLOAT_g;
H5_DLLVAR hid_t H5T_NATIVE_DOUBLE_g;
H5_DLLVAR hid_t H5T_NATIVE_LDOUBLE_g;
H5_DLLVAR hid_t H5T_NATIVE_B8_g;
H5_DLLVAR hid_t H5T_NATIVE_B16_g;
H5_DLLVAR hid_t H5T_NATIVE_B32_g;
H5_DLLVAR hid_t H5T_NATIVE_B64_g;

/*C9x integer types */
#define H5T_NATIVE_INT64		(H5OPEN H5T_NATIVE_INT64_g)
#define H5T_NATIVE_UINT64		(H5OPEN H5T_NATIVE_UINT64_g)

H5_DLLVAR hid_t H5T_NATIVE_INT64_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT64_g;
/*
 * Types particular to the C language.  String types use `bytes' instead of `bits' as their size.
 *
 */
#define H5T_C_S1		(H5OPEN H5T_C_S1_g)
H5_DLLVAR hid_t H5T_C_S1_g;

#define	H5T_VARIABLE (-1)

/* These are the various classes of datatypes */
/* If this goes over 16 types (0-15), the file format will need to change) */
typedef enum H5T_class_t {
    H5T_NO_CLASS         = -1,  /*error                                      */
    H5T_INTEGER          = 0,   /*integer types                              */
    H5T_FLOAT            = 1,   /*floating-point types                       */
    H5T_TIME             = 2,   /*date and time types                        */
    H5T_STRING           = 3,   /*character string types                     */
    H5T_BITFIELD         = 4,   /*bit field types                            */
    H5T_OPAQUE           = 5,   /*opaque types                               */
    H5T_COMPOUND         = 6,   /*compound types                             */
    H5T_REFERENCE      	 = 7,   /*reference types                            */
    H5T_ENUM			 = 8,	/*enumeration types                          */
    H5T_VLEN		 	 = 9,	/*Variable-Length types                      */
    H5T_ARRAY	         = 10,	/*Array types                                */
    H5T_NCLASSES                /*this must be last                          */
} H5T_class_t;
   
    
/* Variable Length Datatype struct in memory */

/* Variable Length Datatype struct in memory */
typedef struct {
    size_t len; /* Length of VL data (in base type units) */
    void *p;    /* Pointer to VL data */
} hvl_t;

/* The order to retrieve atomic native datatype */
typedef enum H5T_direction_t {
    H5T_DIR_DEFAULT     = 0,    /*default direction is inscendent            */
    H5T_DIR_ASCEND      = 1,    /*in inscendent order                        */
    H5T_DIR_DESCEND     = 2     /*in descendent order                        */ 
} H5T_direction_t;
    
H5_DLL hid_t H5Topen2(hid_t loc_id, const char* name, hid_t tapl_id);
H5_DLL hid_t H5Tget_native_type(hid_t type_id, H5T_direction_t direction);
H5_DLL herr_t H5Tclose(hid_t type_id);
H5_DLL H5T_class_t H5Tget_class(hid_t type_id);
H5_DLL size_t H5Tget_size(hid_t type_id);
H5_DLL char *H5Tget_tag(hid_t dtype_id);
H5_DLL herr_t H5Tset_size(hid_t type_id, size_t size);
H5_DLL hid_t H5Tcopy(hid_t type_id);
H5_DLL htri_t H5Tequal(hid_t type1_id, hid_t type2_id);
H5_DLL int H5Tget_nmembers(hid_t type_id);
H5_DLL hid_t H5Tget_member_type(hid_t type_id, uint membno);
H5_DLL char *H5Tget_member_name(hid_t type_id, uint membno);
H5_DLL int H5Tget_member_index(hid_t type_id, const char *name);
H5_DLL size_t H5Tget_member_offset(hid_t type_id, uint membno);
H5_DLL H5T_class_t H5Tget_member_class(hid_t type_id, uint membno);
H5_DLL int H5Tget_array_ndims(hid_t type_id);
H5_DLL int H5Tget_array_dims2(hid_t type_id, hsize_t dims[]);
H5_DLL hid_t H5Tget_super(hid_t type);
H5_DLL htri_t H5Tis_variable_str(hid_t type_id);
H5_DLL hid_t H5Tarray_create2(hid_t base_typ_id, uint rank, const hsize_t dims[/*rank*/]);
H5_DLL herr_t H5Tenum_valueof(hid_t dtype_id, char *name, void *value);
H5_DLL herr_t H5Tenum_nameof(hid_t dtype_id, void *value, char *name, size_t size);
H5_DLL herr_t H5Tget_member_value(hid_t dtype_id, uint memb_no, void *value);
//end H5T

//H5S
#define H5S_ALL         0
/* Different ways of combining selections */
typedef enum H5S_seloper_t {
    H5S_SELECT_NOOP      = -1,  /* error                                     */
    H5S_SELECT_SET       = 0,   /* Select "set" operation 		     */

    H5S_SELECT_OR,              /* Binary "or" operation for hyperslabs
                                 * (add new selection to existing selection)
                                 * Original region:  AAAAAAAAAA

                                 * New region:             BBBBBBBBBB

                                 * A or B:           CCCCCCCCCCCCCCCC
                                                       
                                 */
 
    //Sophy, in HDF5 lib, here are more enum items that we needn't to take care, so I skip them
} H5S_seloper_t;

    
H5_DLL htri_t H5Sis_simple(hid_t space_id);
H5_DLL hid_t H5Screate_simple(int rank, const hsize_t dims[], const hsize_t maxdims[]);
H5_DLL int H5Sget_simple_extent_ndims(hid_t space_id);
H5_DLL int H5Sget_simple_extent_dims(hid_t space_id, hsize_t dims[], hsize_t maxdims[]);
H5_DLL herr_t H5Sselect_hyperslab(hid_t space_id, H5S_seloper_t op, const hsize_t start[], const hsize_t _stride[], const hsize_t count[], const hsize_t _block[]);
H5_DLL herr_t H5Sclose(hid_t space_id);
H5_DLL hssize_t H5Sget_select_npoints(hid_t space_id);
H5_DLL hssize_t H5Sget_simple_extent_npoints(hid_t space_id);
H5_DLL herr_t H5Sselect_all(hid_t spaceid);
//end H5S


//begin H5R
/*
* Reference types allowed.
*/
typedef enum {
    H5R_BADTYPE     =   (-1),   /*invalid Reference Type*/
    H5R_OBJECT,                 /*Object reference                           */
    H5R_DATASET_REGION,         /*Dataset Region Reference                   */
    H5R_MAXTYPE                 /*highest type (Invalid as true type)	     */
} H5R_type_t;
    
    
H5_DLL hid_t H5Rdereference(hid_t dataset, H5R_type_t ref_type, const void *ref);
//end H5R

//H5L

/* Link class types.
 * Values less than 64 are reserved for the HDF5 library's internal use.
 * Values 64 to 255 are for "user-defined" link class types; these types are
 * defined by HDF5 but their behavior can be overridden by users.
 * Users who want to create new classes of links should contact the HDF5
 * development team at hdfhelp@ncsa.uiuc.edu .
 * These values can never change because they appear in HDF5 files.
 */
typedef enum {
    H5L_TYPE_ERROR = (-1),      /* Invalid link type id         */
    H5L_TYPE_HARD = 0,          /* Hard link id                 */
    H5L_TYPE_SOFT = 1,          /* Soft link id                 */
    H5L_TYPE_EXTERNAL = 64,     /* External link id             */
    H5L_TYPE_MAX = 255	        /* Maximum link type id         */
} H5L_type_t;

typedef struct {
    H5L_type_t     type;
    hbool_t        corder_valid;
    int64_t        corder;
    H5T_cset_t     cset;
    /*
    union {
        haddr_t    address;
        size_t     val_size;
    }u;
    */
    int addr_val_size[2]; //Sophy...OC doesn't support nested union type, so I use this to analog...
} H5L_info_t;

herr_t H5Lget_info(hid_t link_loc_id, const char *link_name, H5L_info_t *link_buff, hid_t lapl_id);
herr_t H5Lget_val(hid_t link_loc_id, const char *link_name, void *linkval_buff, size_t size, hid_t lapl_id);
//end H5L

#ifdef __cplusplus
}
#endif

#endif //_OCHDF5_H_
 
 
